/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.agriculture;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.api.capability.player.CapabilityPlayerData;
import net.dries007.tfc.api.types.ICrop;
import net.dries007.tfc.api.util.IGrowingPlant;
import net.dries007.tfc.objects.items.ItemSeedsTFC;
import net.dries007.tfc.util.agriculture.Crop;
import net.dries007.tfc.util.skills.SimpleSkill;
import net.dries007.tfc.util.skills.SkillType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

@ParametersAreNonnullByDefault
public class BlockCropDead
extends BlockBush
implements IGrowingPlant {
    public static final PropertyBool MATURE = PropertyBool.func_177716_a((String)"mature");
    private static final int META_MATURE = 1;
    private static final Map<ICrop, BlockCropDead> MAP = new HashMap<ICrop, BlockCropDead>();
    protected final ICrop crop;

    public static BlockCropDead get(ICrop crop) {
        return MAP.get(crop);
    }

    public static Set<ICrop> getCrops() {
        return MAP.keySet();
    }

    public BlockCropDead(ICrop crop) {
        super(Material.field_151585_k);
        this.crop = crop;
        if (MAP.put(crop, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.6f);
    }

    @Nonnull
    public ICrop getCrop() {
        return this.crop;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)MATURE, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MATURE) != false ? 1 : 0;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemSeedsTFC.get(this.crop);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MATURE});
    }

    @Nonnull
    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.XZ;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int count = 1;
        if (((Boolean)state.func_177229_b((IProperty)MATURE)).booleanValue()) {
            SimpleSkill skill;
            ++count;
            EntityPlayer player = (EntityPlayer)this.harvesters.get();
            if (player != null && (skill = CapabilityPlayerData.getSkill(player, SkillType.AGRICULTURE)) != null) {
                count += Crop.getSkillSeedBonus(skill, RANDOM);
                skill.add(0.04f);
            }
        }
        return count;
    }

    @Nonnull
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)ItemSeedsTFC.get(this.crop));
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    }

    @Nonnull
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    @Override
    public IGrowingPlant.GrowthStatus getGrowingStatus(IBlockState state, World world, BlockPos pos) {
        return IGrowingPlant.GrowthStatus.DEAD;
    }
}

